<?php
namespace infozone\ads\migrations;

class v1 extends \phpbb\db\migration\migration
{
    public function effectively_installed()
    {
        return isset($this->config['infozone_ads_version']) && version_compare($this->config['infozone_ads_version'], '1.0.0', '>=');
    }

    static public function depends_on()
    {
        return ['\phpbb\db\migration\data\v330\v330'];
    }

    public function update_schema()
    {
        return [
            'add_tables' => [
                $this->table_prefix . 'infozone_ad_slots' => [
                    'COLUMNS' => [
                        'id'        => ['UINT', null, 'auto_increment'],
                        'slot_key'  => ['VCHAR:64', ''],
                        'type'      => ['VCHAR:16', 'empty'], // empty|image|html
                        'image_path'=> ['VCHAR:255', ''],
                        'link_url'  => ['VCHAR:255', ''],
                        'html_code' => ['TEXT_UNI', ''],
                        'enabled'   => ['BOOL', 1],
                        'start_at'  => ['TIMESTAMP', 0],
                        'end_at'    => ['TIMESTAMP', 0],
                        'updated_at'=> ['TIMESTAMP', 0],
                    ],
                    'PRIMARY_KEY' => 'id',
                    'KEYS' => [
                        'slot_key' => ['INDEX', 'slot_key'],
                    ],
                ],
                $this->table_prefix . 'infozone_ad_requests' => [
                    'COLUMNS' => [
                        'id'           => ['UINT', null, 'auto_increment'],
                        'created_at'   => ['TIMESTAMP', 0],
                        'status'       => ['VCHAR:16', 'pending'], // pending|paid|approved|rejected|published
                        'fullname'     => ['VCHAR:255', ''],
                        'email'        => ['VCHAR:255', ''],
                        'phone'        => ['VCHAR:64', ''],
                        'company'      => ['VCHAR:255', ''],
                        'target_url'   => ['VCHAR:255', ''],
                        'slots'        => ['VCHAR:255', ''],
                        'duration_days'=> ['UINT', 7],
                        'ad_type'      => ['VCHAR:16', 'image'], // image|html
                        'image_path'   => ['VCHAR:255', ''],
                        'html_code'    => ['TEXT_UNI', ''],
                        'notes'        => ['TEXT_UNI', ''],
                        'amount_kobo'  => ['UINT', 0],
                        'currency'     => ['VCHAR:8', 'NGN'],
                        'payment_ref'  => ['VCHAR:128', ''],
                    ],
                    'PRIMARY_KEY' => 'id',
                    'KEYS' => [
                        'status' => ['INDEX', 'status'],
                    ],
                ],
            ],
        ];
    }

    public function revert_schema()
    {
        return [
            'drop_tables' => [
                $this->table_prefix . 'infozone_ad_slots',
                $this->table_prefix . 'infozone_ad_requests',
            ],
        ];
    }

    public function update_data()
    {
        return [
            ['config.add', ['infozone_ads_version', '1.0.0']],
            ['config.add', ['infozone_ads_paystack_public', '']],
            ['config.add', ['infozone_ads_paystack_secret', '']],
            ['config.add', ['infozone_ads_currency', 'NGN']],
            ['config.add', ['infozone_ads_default_amount_kobo', 500000]],

            ['module.add', [
                'acp',
                'ACP_CAT_DOT_MODS',
                'ACP_INFOZONE_ADS',
            ]],
            ['module.add', [
                'acp',
                'ACP_INFOZONE_ADS',
                [
                    'module_basename' => '\\infozone\\ads\\acp\\ads_module',
                    'modes' => ['manage'],
                ],
            ]],
        ];
    }
}
