# InfoZoneLive Flarum Portal Pack (Modern + Dark + Ads)
Domain target: https://www.infozonelive.com (recommended forum subdomain: https://forum.infozonelive.com)

This ZIP does **NOT** include Flarum core files (because installing Flarum requires Composer downloads from upstream).
It **does** include:
- A theme extension skeleton: `portal-theme/` (modern portal styling + dark mode + ad slot styling)
- Ad slot HTML snippets: `snippets/`
- A JS snippet for an optional dark-mode toggle: `snippets/dark_mode_toggle.js`

## A) Install Flarum (core) on cPanel
1) cPanel → **MySQL Databases**
   - Create DB + user + password
   - Grant ALL privileges
2) cPanel → **Terminal** (or SSH)
   - `cd public_html/forum`  (or your forum document root)
   - `composer create-project flarum/flarum .`
3) Ensure folders are writable:
   - `chmod -R 775 storage assets`

Then open your forum URL and complete the installer.

## B) Install this theme extension
### Option 1 (Preferred): Composer (needs Terminal/SSH)
1) Upload the folder `portal-theme/` somewhere under your home directory (NOT web root), e.g.:
   - `/home/<cpanel_user>/izl/portal-theme`
2) In Terminal, from your Flarum root:
   - `composer config repositories.infozonelive path /home/<cpanel_user>/izl/portal-theme`
   - `composer require infozonelive/portal-theme:*`
   - `php flarum cache:clear`
3) Admin → Extensions → enable **InfoZoneLive Portal Theme**

### Option 2 (Simpler): Paste the CSS/LESS
If you cannot use Composer path repositories:
- Admin → Appearance → Custom CSS/LESS
- Paste the contents of: `portal-theme/resources/less/forum.less`

## C) Add ad slots (header/footer/sidebar/between posts)
### Header + Footer
Admin → Appearance → Custom HTML (or any header/footer extension you use)
- Paste `snippets/ad_header.html` into header area
- Paste `snippets/ad_footer.html` into footer area

### Sidebar
Add a sidebar widget/HTML via an extension (common approach) OR by customizing the theme components.
If you have a “Custom HTML widget” extension, paste `snippets/ad_sidebar.html`.

### Between posts
Flarum does not natively insert HTML between every post without an extension.
Two practical approaches:
1) Place it at the TOP of the first post area (Theme component override)
2) Insert it between discussion list items (index) via a small frontend extension

If you want the “between posts” injection implemented as code, use a small custom extension (I can provide the exact code next).

## D) Dark mode toggle (optional)
If you want a manual toggle button:
1) Add a button in your header HTML, e.g.:
   `<button class="Button Button--primary" onclick="toggleIZLDark()">Dark Mode</button>`
2) Add the JS snippet `snippets/dark_mode_toggle.js` via your header/footer custom HTML (inside <script>...</script>).

## E) SEO essentials (recommended)
From Flarum root:
- `composer require fof/seo fof/sitemap`
Enable in Admin → Extensions
Submit: `https://forum.infozonelive.com/sitemap.xml` in Google Search Console
