<?php
declare(strict_types=1);

namespace InfoZone\Http;

final class Request
{
    public string $method;
    public string $path;
    public array $query;
    public array $post;

    private function __construct(string $method, string $path, array $query, array $post)
    {
        $this->method = strtoupper($method);
        $this->path = $path ?: '/';
        $this->query = $query;
        $this->post = $post;
    }

    public static function fromGlobals(): self
    {
        $uri = $_SERVER['REQUEST_URI'] ?? '/';
        $path = parse_url($uri, PHP_URL_PATH) ?: '/';
        return new self($_SERVER['REQUEST_METHOD'] ?? 'GET', $path, $_GET ?? [], $_POST ?? []);
    }
}
