<?php
declare(strict_types=1);

namespace InfoZone\Security;

use InfoZone\Repository\PermissionRepository;

final class Ability
{
    public static function can(string $permissionKey, ?int $userId = null): bool
    {
        $userId = $userId ?? Auth::userId();
        if (!$userId) return false;
        return (new PermissionRepository())->userHasPermission($userId, $permissionKey);
    }

    public static function require(string $permissionKey): void
    {
        if (!self::can($permissionKey)) {
            http_response_code(403);
            echo 'Forbidden.';
            exit;
        }
    }
}
