<?php
declare(strict_types=1);

namespace InfoZone\Security;

use InfoZone\Repository\UserRepository;

final class Auth
{
    public static function userId(): ?int
    {
        return isset($_SESSION['uid']) ? (int)$_SESSION['uid'] : null;
    }

    public static function user(): ?array
    {
        $uid = self::userId();
        if (!$uid) return null;
        return (new UserRepository())->findById($uid);
    }

    public static function requireLogin(): void
    {
        if (!self::userId()) {
            http_response_code(401);
            echo 'Login required.';
            exit;
        }
    }
}
