<?php
use InfoZone\Support\View;

ob_start();
?>
<div class="d-flex align-items-start justify-content-between mb-3">
  <div>
    <h1 class="h3 fw-bold mb-1">Dashboard</h1>
    <div class="text-muted">Overview and health checks (placeholders).</div>
  </div>
</div>

<div class="row g-3">
  <div class="col-12 col-md-6 col-lg-3">
    <div class="card rounded-4 shadow-sm"><div class="card-body">
      <div class="text-muted small">Total users</div>
      <div class="h4 fw-bold mb-0"><?= (int)$stats['users'] ?></div>
    </div></div>
  </div>
  <div class="col-12 col-md-6 col-lg-3">
    <div class="card rounded-4 shadow-sm"><div class="card-body">
      <div class="text-muted small">Total topics</div>
      <div class="h4 fw-bold mb-0"><?= (int)$stats['topics'] ?></div>
    </div></div>
  </div>
  <div class="col-12 col-md-6 col-lg-3">
    <div class="card rounded-4 shadow-sm"><div class="card-body">
      <div class="text-muted small">Total posts</div>
      <div class="h4 fw-bold mb-0"><?= (int)$stats['posts'] ?></div>
    </div></div>
  </div>
  <div class="col-12 col-md-6 col-lg-3">
    <div class="card rounded-4 shadow-sm"><div class="card-body">
      <div class="text-muted small">Open reports</div>
      <div class="h4 fw-bold mb-0"><?= (int)$stats['reports_open'] ?></div>
    </div></div>
  </div>
</div>

<div class="card rounded-4 shadow-sm mt-4">
  <div class="card-body">
    <h2 class="h6 fw-bold mb-2">Quick actions</h2>
    <div class="d-flex flex-wrap gap-2">
      <a class="btn btn-sm btn-primary rounded-3" href="/acp/forums">Manage forums</a>
      <button class="btn btn-sm btn-outline-primary rounded-3" type="button" disabled>Manage permissions</button>
      <button class="btn btn-sm btn-outline-primary rounded-3" type="button" disabled>Maintenance</button>
    </div>
  </div>
</div>
<?php
$content = ob_get_clean();
echo View::render('layouts/acp.php', compact('content','pageTitle'));
