<?php
use InfoZone\Support\View;

ob_start();
?>
<div class="d-flex align-items-center justify-content-between mb-3">
  <div>
    <h1 class="h3 fw-bold mb-1">Forums</h1>
    <div class="text-muted">Card-style categories and forums, built for mobile first.</div>
  </div>
  <a class="btn btn-primary btn-sm rounded-3" href="/new-topic">New topic</a>
</div>

<?php foreach ($categories as $cat): ?>
  <div class="mb-4">
    <div class="d-flex align-items-center justify-content-between">
      <h2 class="h5 fw-bold mb-2"><?= htmlspecialchars($cat['title']) ?></h2>
      <span class="badge text-bg-light border"><?= (int)count($cat['forums']) ?> forums</span>
    </div>

    <div class="row g-3">
      <?php foreach ($cat['forums'] as $forum): ?>
        <div class="col-12 col-md-6">
          <a class="text-decoration-none" href="/forum/<?= (int)$forum['id'] ?>">
            <div class="card rounded-4 shadow-sm h-100 forum-card">
              <div class="card-body">
                <div class="d-flex align-items-start justify-content-between gap-3">
                  <div>
                    <div class="fw-bold"><?= htmlspecialchars($forum['title']) ?></div>
                    <div class="text-muted small mt-1"><?= htmlspecialchars($forum['description'] ?: 'Discuss here.') ?></div>
                  </div>
                  <div class="text-end">
                    <div class="small text-muted">Topics</div>
                    <div class="fw-semibold"><?= (int)$forum['topic_count'] ?></div>
                  </div>
                </div>
                <div class="mt-3 d-flex flex-wrap gap-2">
                  <span class="badge rounded-pill text-bg-light border">Last post: <?= htmlspecialchars($forum['last_post_at'] ?? '—') ?></span>
                  <?php if ((int)$forum['is_locked'] === 1): ?>
                    <span class="badge rounded-pill text-bg-warning">Locked</span>
                  <?php endif; ?>
                </div>
              </div>
            </div>
          </a>
        </div>
      <?php endforeach; ?>
    </div>
  </div>
<?php endforeach; ?>

<?php
$content = ob_get_clean();
echo View::render('layouts/main.php', compact('content','pageTitle','metaDescription'));
