<?php
use InfoZone\Support\View;

ob_start();
?>
<div class="d-flex align-items-start justify-content-between mb-3">
  <div>
    <nav aria-label="breadcrumb">
      <ol class="breadcrumb small mb-2">
        <li class="breadcrumb-item"><a href="/">Forums</a></li>
        <li class="breadcrumb-item active" aria-current="page"><?= htmlspecialchars($forum['title']) ?></li>
      </ol>
    </nav>
    <h1 class="h3 fw-bold mb-1"><?= htmlspecialchars($forum['title']) ?></h1>
    <div class="text-muted"><?= htmlspecialchars($forum['description'] ?: '') ?></div>
  </div>
  <a class="btn btn-outline-primary btn-sm rounded-3" href="/forum/<?= (int)$forum['id'] ?>/new">Start topic</a>
</div>

<div class="card rounded-4 shadow-sm">
  <div class="card-body p-0">
    <div class="list-group list-group-flush">
      <?php foreach ($topics as $t): ?>
        <a class="list-group-item list-group-item-action py-3" href="/topic/<?= (int)$t['id'] ?>">
          <div class="d-flex justify-content-between align-items-start gap-3">
            <div class="min-w-0">
              <div class="fw-semibold text-truncate">
                <?= ((int)$t['is_pinned'] === 1) ? '📌 ' : '' ?>
                <?= htmlspecialchars($t['title']) ?>
              </div>
              <div class="small text-muted mt-1">
                by <?= htmlspecialchars($t['author_name']) ?> • <?= htmlspecialchars($t['created_at']) ?>
              </div>
              <div class="mt-2 d-flex flex-wrap gap-2">
                <?php if ($t['smart_tags']): ?>
                  <?php foreach (explode(',', (string)$t['smart_tags']) as $tag): ?>
                    <span class="badge rounded-pill text-bg-light border"><?= htmlspecialchars(trim($tag)) ?></span>
                  <?php endforeach; ?>
                <?php else: ?>
                  <span class="badge rounded-pill text-bg-light border">No tags yet</span>
                <?php endif; ?>
              </div>
            </div>
            <div class="text-end flex-shrink-0">
              <div class="small text-muted">Replies</div>
              <div class="fw-semibold"><?= (int)$t['reply_count'] ?></div>
              <div class="small text-muted mt-2">Last: <?= htmlspecialchars($t['last_post_at'] ?? '—') ?></div>
            </div>
          </div>
        </a>
      <?php endforeach; ?>
      <?php if (!$topics): ?>
        <div class="p-4 text-muted">No topics yet.</div>
      <?php endif; ?>
    </div>
  </div>
</div>

<?php
$content = ob_get_clean();
echo View::render('layouts/main.php', compact('content','pageTitle','metaDescription'));
