<?php
/** @var array $app */
/** @var string $pageTitle */
/** @var string $content */
$fullTitle = htmlspecialchars($pageTitle) . ' • ' . htmlspecialchars($app['name']);
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= $fullTitle ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="/assets/app.css" rel="stylesheet">
</head>
<body class="bg-body-tertiary">
<header class="border-bottom bg-white">
  <div class="container py-3 d-flex align-items-center justify-content-between">
    <div class="fw-bold">ACP</div>
    <div class="d-flex gap-2">
      <a class="btn btn-sm btn-outline-secondary" href="/">View site</a>
    </div>
  </div>
</header>

<main class="container my-4">
  <div class="row g-4">
    <aside class="col-12 col-lg-3">
      <div class="card rounded-4 shadow-sm">
        <div class="card-body">
          <div class="fw-semibold mb-2">Sections</div>
          <div class="list-group list-group-flush">
            <a class="list-group-item list-group-item-action" href="/acp">Dashboard</a>
            <a class="list-group-item list-group-item-action" href="/acp/forums">Forums</a>
            <a class="list-group-item list-group-item-action disabled" href="#">Posting (stub)</a>
            <a class="list-group-item list-group-item-action disabled" href="#">Users &amp; Groups (stub)</a>
            <a class="list-group-item list-group-item-action disabled" href="#">Permissions (stub)</a>
            <a class="list-group-item list-group-item-action disabled" href="#">Styles (stub)</a>
            <a class="list-group-item list-group-item-action disabled" href="#">Maintenance (stub)</a>
            <a class="list-group-item list-group-item-action disabled" href="#">System (stub)</a>
          </div>
        </div>
      </div>
    </aside>
    <section class="col-12 col-lg-9">
      <?= $content ?>
    </section>
  </div>
</main>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
