<?php
use InfoZone\Support\View;
use InfoZone\Support\Csrf;

ob_start();
?>
<div class="d-flex flex-column flex-md-row align-items-start justify-content-between gap-3 mb-3">
  <div class="min-w-0">
    <nav aria-label="breadcrumb">
      <ol class="breadcrumb small mb-2">
        <li class="breadcrumb-item"><a href="/">Forums</a></li>
        <li class="breadcrumb-item"><a href="/forum/<?= (int)$topic['forum_id'] ?>"><?= htmlspecialchars($topic['forum_title']) ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?= htmlspecialchars($topic['title']) ?></li>
      </ol>
    </nav>
    <h1 class="h3 fw-bold mb-1"><?= htmlspecialchars($topic['title']) ?></h1>
    <div class="text-muted small">
      Started by <?= htmlspecialchars($topic['author_name']) ?> • <?= htmlspecialchars($topic['created_at']) ?>
      <?php if ($topic['ai_summary']): ?>
        <span class="ms-2 badge rounded-pill text-bg-light border">Smart summary</span>
      <?php endif; ?>
    </div>
    <?php if ($topic['ai_summary']): ?>
      <div class="alert alert-light border rounded-4 mt-3 mb-0">
        <div class="fw-semibold mb-1">AI-style summary (stored now, filled later)</div>
        <div class="small text-muted"><?= htmlspecialchars($topic['ai_summary']) ?></div>
      </div>
    <?php endif; ?>
  </div>

  <div class="d-flex gap-2">
    <button class="btn btn-outline-secondary btn-sm rounded-3" type="button">Follow</button>
    <button class="btn btn-outline-secondary btn-sm rounded-3" type="button">Share</button>
  </div>
</div>

<div class="row g-4">
  <div class="col-12 col-lg-8">
    <div class="vstack gap-3">
      <?php foreach ($posts as $p): ?>
        <article class="card rounded-4 shadow-sm">
          <div class="card-body">
            <div class="d-flex align-items-start justify-content-between gap-3">
              <div class="d-flex align-items-center gap-2">
                <div class="avatar rounded-circle bg-secondary-subtle text-center fw-bold">
                  <?= htmlspecialchars(mb_strtoupper(mb_substr((string)$p['username'], 0, 1))) ?>
                </div>
                <div>
                  <div class="fw-semibold"><?= htmlspecialchars($p['username']) ?></div>
                  <div class="small text-muted">Posted <?= htmlspecialchars($p['created_at']) ?></div>
                </div>
              </div>
              <span class="badge rounded-pill mood-<?= htmlspecialchars($p['mood']) ?>"><?= htmlspecialchars($p['mood']) ?></span>
            </div>

            <div class="mt-3 post-body">
              <?= $p['body_html'] ?>
            </div>

            <div class="mt-3 d-flex gap-2">
              <button class="btn btn-sm btn-light border rounded-3" type="button">Quote</button>
              <button class="btn btn-sm btn-light border rounded-3" type="button">@Mention</button>
              <button class="btn btn-sm btn-light border rounded-3" type="button">Emoji</button>
            </div>
          </div>
        </article>
      <?php endforeach; ?>
    </div>

    <div class="card rounded-4 shadow-sm mt-4">
      <div class="card-body">
        <h2 class="h6 fw-bold mb-3">Reply</h2>
        <form method="post" action="/topic/<?= (int)$topic['id'] ?>/reply">
          <?= Csrf::inputField(); ?>
          <div class="mb-2">
            <label class="form-label small text-muted">Mood indicator</label>
            <select class="form-select form-select-sm" name="mood">
              <option value="neutral">Neutral</option>
              <option value="positive">Positive</option>
              <option value="negative">Negative</option>
              <option value="question">Question</option>
              <option value="announcement">Announcement</option>
            </select>
          </div>
          <div class="mb-3">
            <label class="form-label small text-muted">Markdown (stub — enhance later)</label>
            <textarea class="form-control" name="body" rows="5" placeholder="Write your reply..."></textarea>
          </div>
          <div class="d-flex justify-content-between align-items-center">
            <div class="small text-muted">Supports @mentions, emoji, and quote replies (hooks stubbed).</div>
            <button class="btn btn-primary rounded-3" type="submit">Post reply</button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <aside class="col-12 col-lg-4">
    <div class="card rounded-4 shadow-sm">
      <div class="card-body">
        <h2 class="h6 fw-bold mb-3">Related topics</h2>
        <ul class="list-unstyled mb-0">
          <?php foreach ($related as $r): ?>
            <li class="mb-2">
              <a class="text-decoration-none" href="/topic/<?= (int)$r['id'] ?>">
                <div class="fw-semibold"><?= htmlspecialchars($r['title']) ?></div>
                <div class="small text-muted"><?= htmlspecialchars($r['last_post_at'] ?? '') ?></div>
              </a>
            </li>
          <?php endforeach; ?>
          <?php if (!$related): ?>
            <li class="text-muted small">No related topics yet.</li>
          <?php endif; ?>
        </ul>
      </div>
    </div>

    <div class="card rounded-4 shadow-sm mt-4">
      <div class="card-body">
        <h2 class="h6 fw-bold mb-2">Voice reply (optional, stub)</h2>
        <div class="small text-muted">DB columns exist (`posts.voice_*`). Add upload handler later.</div>
      </div>
    </div>
  </aside>
</div>

<?php
$content = ob_get_clean();
echo View::render('layouts/main.php', compact('content','pageTitle','metaDescription'));
